/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2018 Photon Storm Ltd.
 * @license      {@link https://github.com/photonstorm/phaser/blob/master/license.txt|MIT License}
 */

/**
 * XBox 360 Gamepad Configuration.
 *
 * @name Phaser.Input.Gamepad.Configs.XBOX_360
 * @type {object}
 * @since 3.0.0
 */
module.exports = {

    UP: 12,
    DOWN: 13,
    LEFT: 14,
    RIGHT: 15,

    MENU: 16,

    A: 0,
    B: 1,
    X: 2,
    Y: 3,

    LB: 4,
    RB: 5,

    LT: 6,
    RT: 7,

    BACK: 8,
    START: 9,

    LS: 10,
    RS: 11,

    LEFT_STICK_H: 0,
    LEFT_STICK_V: 1,
    RIGHT_STICK_H: 2,
    RIGHT_STICK_V: 3

};
