/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2018 Photon Storm Ltd.
 * @license      {@link https://github.com/photonstorm/phaser/blob/master/license.txt|MIT License}
 */

/**
 * Phaser Scale Modes.
 * 
 * @name Phaser.ScaleModes
 * @enum {integer}
 * @memberOf Phaser
 * @readOnly
 * @since 3.0.0
 */

module.exports = {

    /**
     * Default Scale Mode (Linear).
     * 
     * @name Phaser.ScaleModes.DEFAULT
     */
    DEFAULT: 0,

    /**
     * Linear Scale Mode.
     * 
     * @name Phaser.ScaleModes.LINEAR
     */
    LINEAR: 0,

    /**
     * Nearest Scale Mode.
     * 
     * @name Phaser.ScaleModes.NEAREST
     */
    NEAREST: 1

};
