/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2018 Photon Storm Ltd.
 * @license      {@link https://github.com/photonstorm/phaser/blob/master/license.txt|MIT License}
 */

/**
 * Filter Types.
 *
 * @name Phaser.Textures.FilterMode
 * @enum {integer}
 * @memberOf Phaser.Textures
 * @readOnly
 * @since 3.0.0
 */
var CONST = {

    /**
     * Linear filter type.
     * 
     * @name Phaser.Textures.FilterMode.LINEAR
     */
    LINEAR: 0,

    /**
     * Nearest neighbor filter type.
     * 
     * @name Phaser.Textures.FilterMode.NEAREST
     */
    NEAREST: 1
    
};

module.exports = CONST;
